package fr.asip.cps3.exemple.vues.ecrans.saisie;

import java.awt.Color;
import java.awt.GridBagLayout;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ScrollPaneConstants;
import javax.swing.border.EmptyBorder;

import fr.asip.cps3.exemple.modele.objets.Algo;
import fr.asip.cps3.exemple.vues.FenetrePrincipale;
import fr.asip.cps3.exemple.vues.composants.GridBagHelper;
import fr.asip.cps3.exemple.vues.ecrans.EcranUtil;

/**
 * Classe permettant de modliser l'cran de saisie d'un Message
 */
public class SaisieMessage extends Saisie {

	/**
	 * Algorithme  prendre en compte pour l'opration
	 */
	protected Algo algo;
	
	/**
	 * Libell Message 
	 */
	protected JLabel libelleMessage;
	
	/**
	 * Texte Message
	 */
	protected JTextArea texteMessage;
	
	/**
	 * Ascenseur du Message
	 */
	protected JScrollPane scrollMessage;
	
	/**
	 * Constructeur
	 * @param fenetre La fentre qui doit contenir l'cran de saisie
	 * @param Type d'cran
	 * @param Algorithme  prendre en compte pour l'opration
	 */
	public SaisieMessage(FenetrePrincipale fenetre, int typeEcran, Algo algo) {

		super(fenetre,typeEcran);
		this.algo = algo; 
		libelleMessage = new JLabel("Entrez le message :");
		texteMessage = new JTextArea();
		texteMessage.setLineWrap(true);
		texteMessage.setWrapStyleWord(true);	
		scrollMessage = new JScrollPane(texteMessage,ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED,ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		scrollMessage.setBackground(Color.white);
    	
	}

	/**
     * Renvoie le message
     * @return Message
     */
	public char[] getMessage() {
		if(texteMessage != null && texteMessage.getText() != null)
			return texteMessage.getText().toCharArray();
		return null;
	}

	/**
     * Accesseur
     * @return Algorithme associ  l'cran
     */
	public Algo getAlgo() {
		return algo;
	}
	
	/**
	 * Affiche les champs d'entre
	 * @param fenetre La fentre qui doit contenir l'cran d'entre
	 */
    public void affiche() {

    	JFrame fenetre = this.fenetre.getFenetre();
    	
    	if(fenetre != null && fenetre.getContentPane() != null) {
    	
	    	EcranUtil.supprimeTousLesComposants(((JPanel)fenetre.getContentPane()));
	    	
	        // Cration du layout
	    	((JPanel)fenetre.getContentPane()).setBorder(new EmptyBorder(0, 0, 0, 0));
	        GridBagLayout layout = new GridBagLayout();
	        ((JPanel)fenetre.getContentPane()).setLayout(layout);
	        
	        // Ajout des composants
	        GridBagHelper g = new GridBagHelper(fenetre.getContentPane());
	        // Ligne 0
	        g.ajoute(libelleMessage, EcranUtil.styleLibelleSaisieMessage, 0, 0, 1, 1);
	        g.ajoute(scrollMessage, EcranUtil.styleScrollSaisieMessage, 0, 1, 1, 1);
	        // Ligne 1
	        g.ajoute(soumettre, EcranUtil.styleBoutonSoumettre, 1, 0, 1, 2);
	        // Ligne 2
	        g.ajoute(barreStatut, EcranUtil.styleBarreStatut, 2, 0, 1, 2);
	        
    	}
    }
}
